/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.actions.NewServerWizardAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerDeleteAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerEditAction;
import org.sonarlint.eclipse.ui.internal.server.actions.ServerUpdateAction;

public class ServerActionProvider
extends CommonActionProvider {
    public static final String NEW_MENU_ID = "org.sonarlint.eclipse.ui.server.newMenuId";
    private ICommonActionExtensionSite actionSite;
    protected Action deleteAction;
    protected Action editAction;
    protected Action updateAction;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            ServerActionProvider.addListeners(cv);
            this.makeServerActions(cv, wsSite.getSelectionProvider());
        }
    }

    private static void addListeners(final CommonViewer tableViewer) {
        tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object data = sel.getFirstElement();
                if (!(data instanceof IServer)) {
                    return;
                }
                IServer server = (IServer)data;
                ServerEditAction.openEditWizard(tableViewer.getTree().getShell(), server);
            }
        });
    }

    private void makeServerActions(CommonViewer tableViewer, ISelectionProvider provider) {
        Shell shell = tableViewer.getTree().getShell();
        this.deleteAction = new ServerDeleteAction(shell, provider);
        this.editAction = new ServerEditAction(shell, provider);
        this.updateAction = new ServerUpdateAction(provider);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.editAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.updateAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.removeAll();
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        ArrayList<IServer> servers = new ArrayList<IServer>();
        if (selection != null && !selection.isEmpty()) {
            for (Object obj : selection) {
                if (!(obj instanceof IServer)) continue;
                servers.add((IServer)obj);
            }
        }
        this.addTopSection(menu);
        menu.add((IContributionItem)new Separator());
        if (servers.size() == 1) {
            menu.add((IAction)this.editAction);
        }
        if (!servers.isEmpty()) {
            menu.add((IAction)this.deleteAction);
            menu.add((IAction)this.updateAction);
        }
    }

    protected void addTopSection(IMenuManager menu) {
        MenuManager newMenu = new MenuManager(Messages.actionNew, NEW_MENU_ID);
        NewServerWizardAction newServerAction = new NewServerWizardAction();
        newServerAction.setText(Messages.actionNewServer);
        newMenu.add((IAction)newServerAction);
        menu.add((IContributionItem)newMenu);
    }
}

